#!/bin/bash
# ./createKey.sh guest guest1234 
# ./createKey.sh test  test1234 
source ./settings.txt

NAME=$1
PASSWORD=$2

echo 'Creating directory ' ${CERT_DIR}
mkdir -p ${CERT_DIR}

echo 'Creating key for ' ${NAME}
echo 'Creating ' ${CERT_DIR}/${NAME}.jks
keytool -genkey -alias ${NAME} -keyalg RSA -keysize 1024 -dname "CN=NiFi ${NAME},OU=SCC,O=SCC,L=Annapolis,S=Maryland,C=US" -keypass ${PASSWORD} -keystore ${CERT_DIR}/${NAME}.jks -storepass ${PASSWORD} -validity 360

echo 'Creating ' ${CERT_DIR}/nifi_${NAME}.p12
keytool -importkeystore -srckeystore ${CERT_DIR}/${NAME}.jks -destkeystore ${CERT_DIR}/${NAME}.p12 -srcstoretype JKS -deststoretype PKCS12 -srcstorepass ${PASSWORD} -deststorepass ${PASSWORD} -srcalias ${NAME} -destalias nifi_${NAME} -srckeypass ${PASSWORD} -destkeypass ${PASSWORD} -noprompt

echo 'Creating ' ${CERT_DIR}/${NAME}.cer
keytool -export -keystore ${CERT_DIR}/${NAME}.jks -storepass ${PASSWORD} -alias ${NAME} -file ${CERT_DIR}/${NAME}.cer

echo 'Adding ' ${CERT_DIR}/${NAME}.cer ' to '  ${CERT_DIR}/truststore.jks
keytool -import -trustcacerts -file ${CERT_DIR}/${NAME}.cer -alias ${NAME} -keystore ${CERT_DIR}/truststore.jks -storepass ${TRUSTSTORE_PASSWORD} -noprompt

echo 'Done creating key for ' ${NAME}


