#!/bin/bash
#ZK_VERSION=3.6.1
#ZK_INSTALL_DIR=/tmp/nifi

source ./settings.txt
echo 'Using ZK version from ./settings.txt file' ${ZK_VERSION}
echo 'Using ZK InstallDir from ./settings.txt file' ${ZK_INSTALL_DIR}

mkdir ${ZK_INSTALL_DIR}
mkdir ${ZK_INSTALL_DIR}1
mkdir ${ZK_INSTALL_DIR}2
mkdir ${ZK_INSTALL_DIR}3

echo wget ${ZK_INSTALL_DIR}/apache-zookeeper-${ZK_VERSION}-bin.tar.gz 
wget -O ${ZK_INSTALL_DIR}/apache-zookeeper-${ZK_VERSION}-bin.tar.gz http://mirror.cc.columbia.edu/pub/software/apache/zookeeper/zookeeper-${ZK_VERSION}/apache-zookeeper-${ZK_VERSION}-bin.tar.gz 

tar -xvf ${ZK_INSTALL_DIR}/apache-zookeeper-${ZK_VERSION}-bin.tar.gz -C ${ZK_INSTALL_DIR}1
tar -xvf ${ZK_INSTALL_DIR}/apache-zookeeper-${ZK_VERSION}-bin.tar.gz -C ${ZK_INSTALL_DIR}2
tar -xvf ${ZK_INSTALL_DIR}/apache-zookeeper-${ZK_VERSION}-bin.tar.gz -C ${ZK_INSTALL_DIR}3

echo 'Making softlink /tmp/zk-current'

ln -s ${ZK_INSTALL_DIR}1/apache-zookeeper-${ZK_VERSION}-bin/ /tmp/zk-current1
ln -s ${ZK_INSTALL_DIR}2/apache-zookeeper-${ZK_VERSION}-bin/ /tmp/zk-current2
ln -s ${ZK_INSTALL_DIR}3/apache-zookeeper-${ZK_VERSION}-bin/ /tmp/zk-current3

cp ./zoo1.cfg ${ZK_INSTALL_DIR}1/apache-zookeeper-${ZK_VERSION}-bin/conf/zoo.cfg
cp ./zoo2.cfg ${ZK_INSTALL_DIR}2/apache-zookeeper-${ZK_VERSION}-bin/conf/zoo.cfg
cp ./zoo3.cfg ${ZK_INSTALL_DIR}3/apache-zookeeper-${ZK_VERSION}-bin/conf/zoo.cfg

echo 1 > /tmp/nifi/zookeeper1/myid
echo 2 > /tmp/nifi/zookeeper2/myid
echo 3 > /tmp/nifi/zookeeper3/myid

rm ${ZK_INSTALL_DIR}/apache-zookeeper-${ZK_VERSION}-bin.tar.gz
rm -Rf ${ZK_INSTALL_DIR}

#./updateNiFiProperties.sh

