#!/bin/bash
#NIFI_VERSION=1.12.0
#INSTALL_DIR=/tmp/nifi
#CERT_DIR=/tmp/nifi/certs
#KEYSTORE_PASSWORD=keyPasswd
#TRUSTSTORE_PASSWORD=trustPasswd
source ./settings.txt
echo 'Using NiFi version from ./settings.txt file' ${NIFI_VERSION}
echo 'Using NiFi InstallDir from ./settings.txt file' ${INSTALL_DIR}
echo 'Using CertDir from ./settings.txt file' ${CERT_DIR}

mkdir ${INSTALL_DIR}
mkdir ${CERT_DIR}
./createKey.sh keystore keyPasswd
./createKey.sh guest guest1234
./createKey.sh admin admin1234
./createKey.sh test test1234

echo wget -O ${INSTALL_DIR}/nifi-${NIFI_VERSION}-bin.tar.gz http://mirror.cc.columbia.edu/pub/software/apache/nifi/${NIFI_VERSION}/nifi-${NIFI_VERSION}-bin.tar.gz

wget -O ${INSTALL_DIR}/nifi-${NIFI_VERSION}-bin.tar.gz http://mirror.cc.columbia.edu/pub/software/apache/nifi/${NIFI_VERSION}/nifi-${NIFI_VERSION}-bin.tar.gz

cp ./demo.tar ${INSTALL_DIR}
tar -xvf ${INSTALL_DIR}/nifi-${NIFI_VERSION}-bin.tar.gz -C ${INSTALL_DIR}
tar -xvf ${INSTALL_DIR}/demo.tar -C ${INSTALL_DIR}/nifi-${NIFI_VERSION}

echo 'Making softlink /tmp/nifi-current'

ln -s /tmp/nifi/nifi-${NIFI_VERSION}/ /tmp/nifi-current

rm ${INSTALL_DIR}/nifi-${NIFI_VERSION}-bin.tar.gz
rm ${INSTALL_DIR}/demo.tar

./updateNiFiProperties.sh

cp ${CERT_DIR}/*p12 ${INSTALL_DIR}/nifi-${NIFI_VERSION}/

