#!/bin/bash
#NIFI_VERSION=1.12.0
#INSTALL_DIR=/tmp/nifi
#CERT_DIR=/tmp/nifi/certs
#KEYSTORE_PASSWORD=keyPasswd
#TRUSTSTORE_PASSWORD=trustPasswd

#NIFI_HTTPS_PORT=8443
#NIFI_PROPS_KEY=Mike
source ./settings.txt
replacements=(
    nifi.remote.input.secure=false:nifi.remote.input.secure=true
    nifi.web.https.port=:nifi.web.https.port=${NIFI_HTTPS_PORT}
    nifi.remote.input.socket.port=:nifi.remote.input.socket.port=10001
    nifi.remote.input.http.enabled=true:nifi.remote.input.http.enabled=false
    nifi.web.https.host=:nifi.web.https.host=127.0.0.1
    nifi.web.http.port=8080:nifi.web.http.port=
    nifi.sensitive.props.key=:nifi.sensitive.props.key=${NIFI_PROPS_KEY}
    nifi.security.keystore=:nifi.security.keystore=${CERT_DIR}/keystore.jks
    nifi.security.keystoreType=:nifi.security.keystoreType=JKS
    nifi.security.keystorePasswd=:nifi.security.keystorePasswd=${KEYSTORE_PASSWORD}
    nifi.security.keyPasswd=:nifi.security.keyPasswd=${KEYSTORE_PASSWORD}
    nifi.security.truststore=:nifi.security.truststore=${CERT_DIR}/truststore.jks
    nifi.security.truststoreType=:nifi.security.truststoreType=JKS
    nifi.security.truststorePasswd=:nifi.security.truststorePasswd=${TRUSTSTORE_PASSWORD}
    nifi.variable.registry.properties=:nifi.variable.registry.properties=./properties.txt
    nifi.zookeeper.connect.string=localhost:nifi.zookeeper.connect.string=localhost:2181,localhost:2182,localhost:2183
    nifi.cluster.is.node=false:nifi.cluster.is.node=true
    nifi.cluster.node.address=127.0.0.1
    nifi.cluster.node.protocol.port=10002
    nifi.cluster.protocol.is.secure=false:nifi.cluster.protocol.is.secure=true
)

for row in "${replacements[@]}"; do
    original="$(echo $row | cut -d: -f1)";
    new="$(echo $row | cut -d: -f2)";
    sed -i -e "s|${original}|${new}|g" ${INSTALL_DIR}/nifi-${NIFI_VERSION}/conf/nifi.properties;
done

