//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private Thr33_Amigos_Bars[] cacheThr33_Amigos_Bars = null;

        private static Thr33_Amigos_Bars checkThr33_Amigos_Bars = new Thr33_Amigos_Bars();

        /// <summary>
        /// EasyEminiTrade Thr33 Amigos bar trend indicator by Integrity Traders, to be used (preferably) on trade chart ONLY, not minute charts!
        /// </summary>
        /// <returns></returns>
        public Thr33_Amigos_Bars Thr33_Amigos_Bars(int period1, int period2, int period3, int timeframe2, int timeframe3)
        {
            return Thr33_Amigos_Bars(Input, period1, period2, period3, timeframe2, timeframe3);
        }

        /// <summary>
        /// EasyEminiTrade Thr33 Amigos bar trend indicator by Integrity Traders, to be used (preferably) on trade chart ONLY, not minute charts!
        /// </summary>
        /// <returns></returns>
        public Thr33_Amigos_Bars Thr33_Amigos_Bars(Data.IDataSeries input, int period1, int period2, int period3, int timeframe2, int timeframe3)
        {
            if (cacheThr33_Amigos_Bars != null)
                for (int idx = 0; idx < cacheThr33_Amigos_Bars.Length; idx++)
                    if (cacheThr33_Amigos_Bars[idx].Period1 == period1 && cacheThr33_Amigos_Bars[idx].Period2 == period2 && cacheThr33_Amigos_Bars[idx].Period3 == period3 && cacheThr33_Amigos_Bars[idx].Timeframe2 == timeframe2 && cacheThr33_Amigos_Bars[idx].Timeframe3 == timeframe3 && cacheThr33_Amigos_Bars[idx].EqualsInput(input))
                        return cacheThr33_Amigos_Bars[idx];

            lock (checkThr33_Amigos_Bars)
            {
                checkThr33_Amigos_Bars.Period1 = period1;
                period1 = checkThr33_Amigos_Bars.Period1;
                checkThr33_Amigos_Bars.Period2 = period2;
                period2 = checkThr33_Amigos_Bars.Period2;
                checkThr33_Amigos_Bars.Period3 = period3;
                period3 = checkThr33_Amigos_Bars.Period3;
                checkThr33_Amigos_Bars.Timeframe2 = timeframe2;
                timeframe2 = checkThr33_Amigos_Bars.Timeframe2;
                checkThr33_Amigos_Bars.Timeframe3 = timeframe3;
                timeframe3 = checkThr33_Amigos_Bars.Timeframe3;

                if (cacheThr33_Amigos_Bars != null)
                    for (int idx = 0; idx < cacheThr33_Amigos_Bars.Length; idx++)
                        if (cacheThr33_Amigos_Bars[idx].Period1 == period1 && cacheThr33_Amigos_Bars[idx].Period2 == period2 && cacheThr33_Amigos_Bars[idx].Period3 == period3 && cacheThr33_Amigos_Bars[idx].Timeframe2 == timeframe2 && cacheThr33_Amigos_Bars[idx].Timeframe3 == timeframe3 && cacheThr33_Amigos_Bars[idx].EqualsInput(input))
                            return cacheThr33_Amigos_Bars[idx];

                Thr33_Amigos_Bars indicator = new Thr33_Amigos_Bars();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.Period1 = period1;
                indicator.Period2 = period2;
                indicator.Period3 = period3;
                indicator.Timeframe2 = timeframe2;
                indicator.Timeframe3 = timeframe3;
                Indicators.Add(indicator);
                indicator.SetUp();

                Thr33_Amigos_Bars[] tmp = new Thr33_Amigos_Bars[cacheThr33_Amigos_Bars == null ? 1 : cacheThr33_Amigos_Bars.Length + 1];
                if (cacheThr33_Amigos_Bars != null)
                    cacheThr33_Amigos_Bars.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheThr33_Amigos_Bars = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// EasyEminiTrade Thr33 Amigos bar trend indicator by Integrity Traders, to be used (preferably) on trade chart ONLY, not minute charts!
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.Thr33_Amigos_Bars Thr33_Amigos_Bars(int period1, int period2, int period3, int timeframe2, int timeframe3)
        {
            return _indicator.Thr33_Amigos_Bars(Input, period1, period2, period3, timeframe2, timeframe3);
        }

        /// <summary>
        /// EasyEminiTrade Thr33 Amigos bar trend indicator by Integrity Traders, to be used (preferably) on trade chart ONLY, not minute charts!
        /// </summary>
        /// <returns></returns>
        public Indicator.Thr33_Amigos_Bars Thr33_Amigos_Bars(Data.IDataSeries input, int period1, int period2, int period3, int timeframe2, int timeframe3)
        {
            return _indicator.Thr33_Amigos_Bars(input, period1, period2, period3, timeframe2, timeframe3);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// EasyEminiTrade Thr33 Amigos bar trend indicator by Integrity Traders, to be used (preferably) on trade chart ONLY, not minute charts!
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.Thr33_Amigos_Bars Thr33_Amigos_Bars(int period1, int period2, int period3, int timeframe2, int timeframe3)
        {
            return _indicator.Thr33_Amigos_Bars(Input, period1, period2, period3, timeframe2, timeframe3);
        }

        /// <summary>
        /// EasyEminiTrade Thr33 Amigos bar trend indicator by Integrity Traders, to be used (preferably) on trade chart ONLY, not minute charts!
        /// </summary>
        /// <returns></returns>
        public Indicator.Thr33_Amigos_Bars Thr33_Amigos_Bars(Data.IDataSeries input, int period1, int period2, int period3, int timeframe2, int timeframe3)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.Thr33_Amigos_Bars(input, period1, period2, period3, timeframe2, timeframe3);
        }
    }
}
#endregion
